# TwinBridge v1.1 — Ed25519 Signing & Key Rotation Specification (Locked)

## Goals
- Integrity and provenance of manifests
- Deterministic verification
- Key rotation with grace window
- Immediate revocation on compromise

## Canonicalization (TwinBridge Canon v1)
Before hashing, the manifest MUST be canonicalized:
- UTF-8
- Object keys sorted lexicographically
- No insignificant whitespace
- Arrays preserve order

Implementations may use RFC 8785 (JCS) if preferred.

## Digest
`manifest_digest = SHA-256(canonical_json(manifest))`

Store as:
- `sha256:<lowercase-hex>`
Sign the raw 32 digest bytes.

## Signature Object
The manifest may contain:

```json
"signatures": {
  "primary": {
    "alg": "Ed25519",
    "kid": "xalina-kms-prod-2026-01",
    "created_at": "2026-01-17T12:00:00Z",
    "manifest_digest": "sha256:<hex>",
    "sig": "<base64>",
    "cert_chain": ["trust-root.json#keys/xalina-kms-prod-2026-01"]
  }
}
```

## Trust Root
A `trust-root.json` lists allowed public keys and revocations. Verification MUST:
- Reject revoked keys
- Enforce not_before/not_after
- Enforce policy on active/grace/retired acceptance
- Verify Ed25519 signature over digest bytes

## Rotation Policy (Default)
- Accept: `active`, `grace`
- Accept `retired` only with explicit archival flag and time-window checks
- Never accept `revoked`

## CLI Additions
- `twinbridge sign ...`
- `twinbridge verify ...`
- `twinbridge trust rotate ...`
- `twinbridge trust revoke ...`
