# Key Rotation & Revocation (Operational Policy)

## Rotation
1. Introduce new key as `active` with `not_before`.
2. Mark previous key as `grace` for `N` days.
3. After grace, mark previous key as `retired` (no new signatures).
4. Optionally allow archival verification with `--allow-retired`.

## Revocation
If compromise is suspected:
- Mark key as `revoked` immediately.
- Verification MUST fail for any manifest signed by that key regardless of age.

## Enterprise Guidance
- Private keys should be held in KMS/HSM.
- Signing should be performed in CI or controlled build systems.
- Developer signing should be restricted to non-production trust roots.
